-- Terminierung 2020


-- Resourcen / Arbeitsplätz Funktionaliäten
  -- Funktion löst ksb_ks_shorthand in Kostenstelle und Arbeitsplatz auf
  CREATE OR REPLACE FUNCTION scheduling.resource__translate__ksvba__shorthand__to__ks_abt__ks_ba_bz(
      IN  _shorthand character varying,
      OUT ks_abt     character varying,
      OUT ks_ba_bz   character varying
      )
      RETURNS record
      AS $$
         SELECT ksb_ks_abt     AS ks_abt,
                ksb_ks_ba_babz AS ks_ba_bz
           FROM ksvba
          WHERE ksb_ks_shorthand = _shorthand;
     $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;


  -- TODO Resource_Reset: tabk.ab2__resource_requirements_options__ksvba__from__ab2__create

  -- Gibt für MON /1 die Ressouce_id zurück
  SELECT tsystem.function__drop_by_regex( 'resource__translate__ksvba__shorthand__to__resource_id', 'scheduling', _commit => true );
  CREATE OR REPLACE FUNCTION scheduling.resource__translate__ksvba__shorthand__to__resource_id(_shorthand VARCHAR)
      RETURNS integer
      AS $$
        SELECT resource.id
          FROM ksvba
          JOIN scheduling.resource ON context_id = ksb_id AND context = 'ksvba'
         WHERE ksb_ks_shorthand = _shorthand;
      $$ LANGUAGE SQL STABLE PARALLEL SAFE STRICT;


  SELECT tsystem.function__drop_by_regex( 'resource__translate__ksvba__to__resource_id', 'scheduling', _commit => true );
  CREATE OR REPLACE FUNCTION scheduling.resource__translate__ksvba__to__resource_id(_ksvba ksvba)
      RETURNS integer
      AS $$
        SELECT resource.id
          FROM scheduling.resource
         WHERE context_id = _ksvba.ksb_id
           AND context = 'ksvba'
      $$ LANGUAGE SQL STABLE PARALLEL SAFE STRICT;

  -- Gibt für eine Resource_id das Shorthand zurück (zB MON /1)

  SELECT tsystem.function__drop_by_regex( 'resource__translate__resource_id__to__ksvba__shorthand', 'scheduling', _commit => true );
  CREATE OR REPLACE FUNCTION scheduling.resource__translate__resource_id__to__ksvba__shorthand( -- TODO: ohne shorthand!
      IN  _resource_id integer
      )
      RETURNS ksvba
      AS $$
        SELECT ksvba.*
          FROM ksvba
          JOIN scheduling.resource ON context_id = ksb_id AND context = 'ksvba'
         WHERE resource.id = _resource_id;
      $$ LANGUAGE SQL STABLE PARALLEL SAFE STRICT;

  SELECT tsystem.function__drop_by_regex( 'resource__ksvba__caption', 'scheduling', _commit => true );
  CREATE OR REPLACE FUNCTION scheduling.resource__ksvba__caption(_ksvba ksvba, _resource_id_debugstring integer = null) RETURNS varchar(100)
      AS $$
        SELECT CASE WHEN NullIf(_ksvba.ksb_ks_ba_babz, '') IS null THEN _ksvba.ksb_ks_shorthand ELSE _ksvba.ksb_ks_abt END || coalesce('(' || _ksvba.ksb_ks_ba_babz || ')', '') || coalesce(' {' || _resource_id_debugstring || '}', '')
      $$ LANGUAGE SQL STABLE PARALLEL SAFE;
  --
  CREATE OR REPLACE FUNCTION scheduling.resource__ksvba__caption(_resource_id integer, _resource_id_debugstring boolean = false) RETURNS varchar(100)
      AS $$
        SELECT scheduling.resource__ksvba__caption( scheduling.resource__translate__resource_id__to__ksvba__shorthand(_resource_id), IFTHEN(_resource_id_debugstring, _resource_id, null)::integer );
      $$ LANGUAGE sql STABLE PARALLEL SAFE;


  -- Funktion gibt mögliche Resourcen zurück, auf die terminiert werden könnte
  SELECT tsystem.function__drop_by_regex( 'ab2__resource_options__ksvba__shorthand__by__a2_id', 'scheduling', _commit => true );
  CREATE OR REPLACE FUNCTION scheduling.ab2__resource_options__ksvba__shorthand__by__a2_id( -- TODO: ohne shorthand!
      IN  _a2_id integer
      )
      RETURNS SETOF ksvba /*ksb_ks_shorthand*/
      AS $$
        /*
        SELECT DISTINCT ksb_ks_shorthand, ksb_id, ksb_ks_id
          FROM ab2
          JOIN LATERAL (SELECT DISTINCT ti_resource_id FROM scheduling.resource_timeline WHERE a2_id = ti_a2_id) AS x ON true
          JOIN scheduling.resource__translate__resource_id__to__ksvba__shorthand(ti_resource_id) AS translate ON true
         WHERE a2_id = _a2_id
        */
        -- TODO: über Parameter steuern, das er nur dier erste zurückgibt? ORDER BY resource_option = ab2.a2_ks LIMIT 1 ????? => resource_timeline__resource_id_main_resource__get
        -- Kopfkostenstelle?
        SELECT ksvba.*
               -- ich als ab2 benötige
          FROM scheduling.resource res_ab2                      -- ON res_ab2.context_id = a2_id AND res_ab2.context = 'ab2'
               -- was: Kostenstelle/Resource(n)
          JOIN scheduling.resource_requirement res_req          ON res_req.required_by = res_ab2.id AND res_req.context = 'ksvba'
               -- und zwar diese:
          JOIN scheduling.resource_requirement_option res_opt   ON res_opt.requirement_id = res_req.id
               -- die Resource (ksvba) wiederrum steht in der Liste der Resourcen
          JOIN scheduling.resource res_ksvba                    ON res_ksvba.id = res_opt.resource_id AND res_ksvba.context = 'ksvba'
               -- darüber kommen wir zum Ursprung zurück
          JOIN ksvba                                            ON ksb_id = res_ksvba.context_id
               -- JOIN ksv ON ks_id = ksb_ks_id
         WHERE res_ab2.context_id = _a2_id AND res_ab2.context = 'ab2'
          ;
      $$ LANGUAGE SQL STABLE PARALLEL SAFE STRICT;


  -- Funktion gibt mögliche Resourcen zurück, auf die terminiert wurde
  SELECT tsystem.function__drop_by_regex( 'ab2__resource_terminated__ksvba__shorthand__by__a2_id', 'scheduling', _commit => true );
  CREATE OR REPLACE FUNCTION scheduling.ab2__resource_terminated__ksvba__shorthand__by__a2_id(
      IN  _a2_id integer
      )
      RETURNS SETOF ksvba /*ksb_ks_shorthand*/
      AS $$
        -- dürfte nie mehr als ein Datensatz sein nach aktueller Implementierung!
        SELECT DISTINCT ksvba
          FROM ab2
          LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1
          -- JOIN LATERAL ( SELECT DISTINCT ti_resource_id FROM scheduling.resource_timeline WHERE a2_id = ti_a2_id AND ti_resource_id = scheduling.resource_timeline__resource_id_main_resource__get( a2_id ) ) AS x ON true
          JOIN scheduling.resource__translate__resource_id__to__ksvba__shorthand( a2w_resource_id_main_terminated ) AS ksvba ON true
         WHERE a2_id = _a2_id
        ;
      $$ LANGUAGE SQL STABLE PARALLEL SAFE STRICT;


  -- Ressource: Arbeitslücken komplett ohne Auftrag (auch keine Teillast)
  SELECT tsystem.function__drop_by_regex( 'resource_timeline__resource__gaps__get', 'scheduling', _commit => true );
  CREATE OR REPLACE FUNCTION scheduling.resource_timeline__resource__gaps__get(
      IN  _ressource_id integer,
      OUT gap_date_start timestamp without time zone,
      OUT gap_date_end timestamp without time zone
      )
      -- Es wird der Abstand von Vorgänger und Nachfolger in ressource_timeline als Lücke ausgewiesen
      RETURNS SETOF record
      AS $$
         WITH
            prevnext AS (
              SELECT ti_date_end,
                     lead( ti_date_start ) OVER ( ORDER BY ti_date_start ) AS next_start
                FROM
                     scheduling.resource_timeline
               WHERE ti_resource_id = _ressource_id
               ORDER BY ti_date_start
            )
          SELECT ti_date_end, next_start
            FROM prevnext
           WHERE ti_date_end < next_start

      $$ LANGUAGE SQL PARALLEL SAFE STRICT;
--

-- ABK / AB2 Funktionalitäten

  -- TODO?! Ändert alle Vorkommen der Ressource id1 zu id2 in der gesamten ABK
  SELECT tsystem.function__drop_by_regex( 'abk__resource_move', 'scheduling', _commit => true );
  CREATE OR REPLACE FUNCTION scheduling.abk__resource_move(
      IN _ab_ix INTEGER,
      IN _a2_id INTEGER,
      IN _from_resource_id INTEGER,
      IN _to_resource_id INTEGER
      )
      RETURNS integer
      AS $$
      BEGIN
        -- TODO ruft scheduler__ressource_move__ab2 auf
      END $$ LANGUAGE plpgsql;
  --

 -- SELECT tsystem.function__drop_by_regex('scheduler__ab2__resource_timeline__ti_date__min_max__get', 'tabk', true, true);
 /*
 CREATE OR REPLACE FUNCTION scheduling.ab2__resource_timeline__ti_date__min_max__get(
    IN  _a2_id                integer,
    OUT ti_date_start__min    timestamp without time zone,
    OUT ti_date_end__max      timestamp without time zone,
    OUT ti_resource_id        integer
    )
    RETURNS record
    AS $$
       SELECT min(ti_date_start) AS ti_date_start__min,
              max(ti_date_end)   AS ti_date_end__max,
              rt.ti_resource_id
         FROM scheduling.resource_timeline rt
        WHERE ti_a2_id = _a2_id
          -- sonst habenwir auch task.blocktime (also überhang sonstwo) was ist nun aber richtiger? ....
         AND ti_type IN ( 'task', 'task.buffer' )
        GROUP BY rt.ti_resource_id;
    $$ LANGUAGE SQL STABLE STRICT PARALLEL SAFE;
 */


 SELECT tsystem.function__drop_by_regex( 'ab2__resource_timeline__ti_date__min_max__get', 'scheduling', _commit => true );
 CREATE OR REPLACE FUNCTION scheduling.ab2__resource_timeline__ti_date__min_max__get(
    IN  _a2_id                integer,
    OUT ti_date_start__min    timestamp without time zone,
    OUT ti_date_end__max      timestamp without time zone
    )
    RETURNS record
    AS $$
       SELECT min( rt.ti_date_start ) AS ti_date_start__min,
              max( rt.ti_date_end )   AS ti_date_end__max
         FROM scheduling.resource_timeline AS rt
        WHERE rt.ti_a2_id = _a2_id
          -- sonst habenwir auch task.blocktime (also überhang sonstwo) was ist nun aber richtiger? ....
         AND rt.ti_type IN ( 'task', 'task.buffer' )
         AND NOT scheduling.resource__is_top_resource( _resource_id => rt.ti_resource_id )
      --  GROUP BY rt.ti_a2_id, rt.ti_resource_id;
    $$ LANGUAGE SQL STABLE STRICT PARALLEL SAFE;



 SELECT tsystem.function__drop_by_regex( 'ab2__resource_timeline__ti_date__min_max__by__a2ids__get', 'scheduling', _commit => true );
 CREATE OR REPLACE FUNCTION scheduling.ab2__resource_timeline__ti_date__min_max__by__a2ids__get(
        VARIADIC _a2_ids      integer[],
    OUT ti_a2_id              integer,
    OUT ti_date_start__min    timestamp without time zone,
    OUT ti_date_end__max      timestamp without time zone,
    OUT ti_resource_id        integer
    )
    RETURNS SETOF record
    AS $$
       SELECT ti_a2_id,
              min(ti_date_start) AS ti_date_start__min,
              max(ti_date_end)   AS ti_date_end__max,
              rt.ti_resource_id
         FROM scheduling.resource_timeline AS rt
        WHERE ti_a2_id = ANY( _a2_ids )
          -- sonst habenwir auch task.blocktime (also überhang sonstwo) was ist nun aber richtiger? ....
         AND ti_type IN ( 'task', 'task.buffer' )
         AND NOT scheduling.resource__is_top_resource( _resource_id => rt.ti_resource_id )
       GROUP BY rt.ti_a2_id, rt.ti_resource_id;
    $$ LANGUAGE SQL STABLE STRICT PARALLEL SAFE;


 SELECT tsystem.function__drop_by_regex( 'abk__resource_timeline__ti_date__min_max__get', 'scheduling', _commit => true );
 CREATE OR REPLACE FUNCTION scheduling.abk__resource_timeline__ti_date__min_max__get(
    IN  _ab_ix integer,
    OUT ti_date_start__min timestamp without time zone,
    OUT ti_date_end__max timestamp without time zone
    )
    RETURNS record
    AS $$
       SELECT min(ti_date_start__min) AS ti_date_start__min,
              max(ti_date_end__max)   AS ti_date_end__max
         FROM ab2
         LEFT JOIN LATERAL scheduling.ab2__resource_timeline__ti_date__min_max__get(a2_id) ON true
        WHERE a2_ab_ix = _ab_ix
    $$ LANGUAGE SQL STABLE STRICT PARALLEL SAFE;
 --

-- TODO SCHEMA tabk? scheduling?
-- Das Datum des laut Plantafel geplanten Fertigstellungstermins (nur Terminwoche bisher). Verwendung: Assistent Warenwirtschaft - Auslieferungen; Lieferliste
-- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Auftg
-- Plantafel-Endtermin des letzten Arbeitsgangs für eine ABK zurückgeben
SELECT tsystem.function__drop_by_regex( 'abk_get_ag_et', 'tplanterm', _cascade => true, _commit => true );
CREATE OR REPLACE FUNCTION tplanterm.abk_get_ag_et(_abk abk) RETURNS integer AS $$
    SELECT termweek(_abk.ab_et) WHERE NOT _abk.ab_done
    -- SELECT termweek(ti_date_end__max)
    --   FROM scheduling.abk__resource_timeline__ti_date__min_max__get(_abix)
 $$ LANGUAGE sql STRICT STABLE PARALLEL SAFE;
--
CREATE OR REPLACE FUNCTION tplanterm.abk_get_ag_et(_abix integer) RETURNS integer AS $$
    SELECT tplanterm.abk_get_ag_et(abk) FROM abk WHERE ab_ix = _abix
    -- SELECT termweek(ti_date_end__max)
    --   FROM scheduling.abk__resource_timeline__ti_date__min_max__get(_abix)
 $$ LANGUAGE sql STRICT STABLE PARALLEL SAFE;

-- Plantafel-Endtermin eines Auftrags, dazu ABK des Auftrags
SELECT tsystem.function__drop_by_regex( 'auftg_get_AG_ET', 'tplanterm', _cascade => true, _commit => true );
CREATE OR REPLACE FUNCTION tplanterm.auftg_get_AG_ET(_agid integer) RETURNS integer AS $$
    SELECT tplanterm.abk_get_AG_ET(tplanterm.auftg_get_abk(_agid));
 $$ LANGUAGE sql STRICT STABLE PARALLEL SAFE;

-- Gibt mir zu dem angegebenen AG den Vorgänger auf der Resource (also den vorherigen AG in der Reihenfolge der Terminierung, kann aus einer anderen ABK sein!) => scheduling.ab2__next_prior__terminated__get
SELECT tsystem.function__drop_by_regex( 'ab2__prior__terminated_on_resource__a2_id__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__prior__terminated_on_resource__a2_id__get(
   IN _a2_id integer
   )
   RETURNS integer
   AS $$
      -- Prior Operation in Resource.
      -- Means get min start of current, prior operation has a EndDate smaller than that.
      SELECT ti_a2_id
        FROM scheduling.resource_timeline,
           (SELECT ti_date_start  AS _rt_ti_date_start,
                   ti_resource_id AS _rt_ti_resource_id
              FROM scheduling.resource_timeline
             WHERE ti_a2_id = _a2_id
             ORDER BY ti_date_start ASC
             LIMIT 1
             ) AS current_rt
       WHERE ti_date_end    <= _rt_ti_date_start
         AND ti_resource_id = _rt_ti_resource_id
         AND ti_type IN ( 'task', 'task.buffer' )
       ORDER BY
           ti_date_end DESC
       LIMIT 1
   $$ LANGUAGE SQL STABLE STRICT PARALLEL SAFE;

-- Gibt mir zu dem angegebenen AG den Nachfolger auf der Resource (also den nächsten AG in der Reihenfolge der Terminierung, kann aus einer anderen ABK sein!) => scheduling.ab2__next_prior__terminated__get
SELECT tsystem.function__drop_by_regex( 'ab2__next__terminated_on_resource__a2_id__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__next__terminated_on_resource__a2_id__get(
   IN _a2_id integer
   )
   RETURNS integer
   AS $$
     -- Next Operation in Resource.
     -- Means get max end of current, next operation has a Start_Date Larger than that.
     SELECT ti_a2_id
       FROM scheduling.resource_timeline,
           (SELECT ti_date_end    AS _rt_ti_date_end,
                   ti_resource_id AS _rt_ti_resource_id
              FROM scheduling.resource_timeline
             WHERE ti_a2_id = _a2_id
             ORDER BY ti_date_end DESC
             LIMIT 1
             )
             AS current_rt
      WHERE ti_date_start  >= _rt_ti_date_end
        AND ti_resource_id = _rt_ti_resource_id
        AND ti_type IN ( 'task', 'task.buffer' )
      ORDER BY
           ti_date_start ASC
      LIMIT 1
   $$ LANGUAGE SQL STABLE STRICT PARALLEL SAFE;



SELECT tsystem.function__drop_by_regex( 'abk__termination_clear', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.abk__termination_clear( -- aus_term
    IN _ab_ix      integer   DEFAULT NULL,
    IN _a2_ids     integer[] DEFAULT null,
    IN _resource_id_main_fix__Reset boolean DEFAULT false
    )
    RETURNS void
    AS $$
    DECLARE _start_time time;
    BEGIN

      IF _ab_ix IS null AND _a2_ids IS null THEN -- zB FolgeABK austerminieren, aber es gibt keine
        RETURN;
      END IF;

      -- entweder AG Bereich als Eingang oder aus ABK-Index alle AGs
      IF _a2_ids IS null THEN
        _a2_ids := array_agg(a2_id ORDER BY a2_n) FROM ab2 WHERE a2_ab_ix = _ab_ix;
      END IF;

      _start_time := clock_timestamp()::time;

      -- entfernt Termine in ab2. Trigger greift NICHT, da in Flag "Automatische Terminierung NICHT true"
      DELETE
        FROM scheduling.resource_timeline
       WHERE ti_a2_id = ANY(_a2_ids)
      ;
      -- Trigger synced NICHT, da execution flag NICHT gesetzt.
      UPDATE ab2 SET a2_at = null, a2_et = null, a2_interm = false
       WHERE NOT a2_ende
         AND a2_id = ANY(_a2_ids)
      ;

      -- Gemerkte Hauptressource (Spalte a2w_resource_id_main_terminated) löschen.
      UPDATE ab2_wkstplan
         SET a2w_resource_id_main_terminated = null,
             a2w_planweek = null,
             a2w_endweek = null,
             -- komplettt zurücksetzen. Damit wird beim nächsten Terminieren definitiv neu "gewürfelt"
             a2w_resource_id_main_fix = IfThen(_resource_id_main_fix__Reset, null, a2w_resource_id_main_fix) -- NICHT ins WHERE da nur die 2.Spalte davon betroffen
       WHERE a2w_a2_id = ANY(_a2_ids)
      ;

      RAISE NOTICE 'abk__termination_clear ABK:%, _a2_ids:%, Duration:%, Start:%, Leave:%', _ab_ix, _a2_ids, clock_timestamp()::time - _start_time, _start_time, clock_timestamp()::time;

      PERFORM TSystem.execution_flag__aquire( _flagname => 'inTerminierung' ); -- Automatisches Terminieren deaktivieren! zB Airbus Terminierung! Wird auch von äußerer Funktion abk_austerm gesetzt!
      IF _ab_ix IS null THEN
        PERFORM scheduling.abk__at_et__from__ab2__sync(a2_ab_ix) FROM (SELECT DISTINCT a2_ab_ix FROM ab2 WHERE a2_id = ANY(_a2_ids)) AS abks; -- =>  abk__a_iud => materialtermine weg => abk__ldsdok__term_set
      ELSE
        PERFORM scheduling.abk__at_et__from__ab2__sync(_ab_ix); -- =>  abk__a_iud => materialtermine weg => abk__ldsdok__term_set
      END IF;
      PERFORM TSystem.execution_flag__release( _flagname => 'inTerminierung' );

    END $$ LANGUAGE plpgsql;

SELECT tsystem.function__drop_by_regex( 'abk__termination_clear__from_to__a2_n', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.abk__termination_clear__from_to__a2_n(
     IN _ab_ix       integer,
     IN _a2_n__start integer,
     IN _a2_n__stop  integer   DEFAULT null,
     IN _resource_id_main_fix__Reset boolean DEFAULT false,
     IN _ab2_groups__recursive boolean DEFAULT true
     )
     RETURNS void
     AS $$
     BEGIN
         -- https://ci.prodat-sql.de/sources/tests/suite/9/runner/1232#teststep-19888 DEBUG STATEMENT
         PERFORM scheduling.abk__termination_clear(_a2_ids => a2_id_to__arr, _resource_id_main_fix__Reset => _resource_id_main_fix__Reset)
                FROM (SELECT array_agg(unnest) AS a2_id_to__arr
                       FROM (SELECT unnest(chain)
                               FROM (SELECT DISTINCT array_remove(ARRAY[CASE WHEN a2_id_chain IS null THEN a2_id ELSE null::integer END] || a2_id_chain, null) AS chain
                                       FROM ab2 LEFT JOIN LATERAL (SELECT array_agg(a2_id_chain) AS a2_id_chain FROM tabk.ab2_groups__recursive__by__a2_id__get( a2_id )) AS chain ON _ab2_groups__recursive
                                      WHERE a2_ab_ix = _ab_ix
                                        AND a2_n BETWEEN coalesce(_a2_n__start, 0) AND coalesce(nullif(_a2_n__stop, 0), 9999999999)
                                      -- ORDER BY a2_n > geht nicht!
                                     ) AS arr
                            ) AS list
                     ) AS sub;
     END
     $$ LANGUAGE plpgsql; -- kann auch SQL, aber Funktionsreihenfolge und sowieso Einzelaufruf


SELECT tsystem.function__drop_by_regex( 'ab2_wkstplan__resource_id_main_fix__clear', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2_wkstplan__resource_id_main_fix__clear(
    IN _a2_id integer
    )
    RETURNS void
    AS $$
    BEGIN
        UPDATE ab2_wkstplan SET a2w_resource_id_main_fix = NULL WHERE a2w_a2_id = _a2_id;
        RETURN;
    END $$ LANGUAGE plpgsql;
--

--
SELECT tsystem.function__drop_by_regex( 'auftgi__art_mat__bfr__max__by__ab_ix', 'tabk', _commit => true );
CREATE OR REPLACE FUNCTION tabk.auftgi__art_mat__bfr__max__by__ab_ix(IN _ab_ix integer) RETURNS integer
    AS $$
        SELECT max(ak_bfr) FROM art WHERE ak_nr IN (SELECT ag_aknr FROM auftg WHERE ag_parentabk IN (SELECT * FROM tplanterm.get_all_child_abk(_ab_ix) ) )
    $$ LANGUAGE sql STABLE PARALLEL SAFE;